/* Script Name:   FindStringsToNewFile
   Creation Date: 2012-10-01
   Last Modified: 2022-05-29
   Copyright:     Copyright (c) 2022 by Mofi
   Original:      https://www.ultraedit.com/resources/scripts/FindStringsToNewFile.zip
                  http://forums.ultraedit.com/viewtopic.php?f=52&t=12866

Please read first FindStringsReadMe.txt before using this script.

The script can be used on small files as well as on larger files with
some MiB and is written for maximum performance by using only memory.

Open the output window by clicking on Output Window in menu Window or by
moving mouse pointer over the tab of the output window (docked auto-hidden
output window) if the script execution is canceled unexpected.

This script cannot be used for very large files. If you can read in output
window

      An error occurred on line 113:
        /
      Script failed.

an error occurred on the line with  UltraEdit.activeDocument.selection.match
because the file is too large respectively too many or too long strings are
found. Use the script FindStringsToNewFilesExtended.js which works also for
very large files, but is slower as it processes the large file in several
steps.

This script is copyrighted by Mofi for free usage by UE/UES users. The
author cannot be made responsible for any damage caused by this script.
You use it at your own risk. */


// Regular expression search string to use. The user of the script is asked
// to enter the regular expression search string if this string is empty.
var sSearchString = "";

// Regular expression replace string to specify a special output for the
// found strings in case of using marking (tagging) groups (round brackets).
// The user of the script is asked to enter the regular expression replace
// string for a special output format if this string is empty.
var sReplaceString = "";


// === OutputMessage =========================================================

// This function displays a message in a message box or write the message into
// a new file for users of UltraEdit for Windows v13.00 or UEStudio v6.20.
function OutputMessage (sMessageText)
{
   if (UltraEdit.messageBox) UltraEdit.messageBox(sMessageText);
   else
   {
      UltraEdit.newFile();
      UltraEdit.activeDocument.unixMacToDos();
      UltraEdit.activeDocument.unicodeToASCII();
      UltraEdit.activeDocument.write(sMessageText.replace(/\n/g,"\r\n"));
      UltraEdit.activeDocument.insertLine();
   }
}


// === FindStringsToNewFile ==================================================

if (UltraEdit.document.length > 0)     // Is any file currently opened?
{
   UltraEdit.insertMode();             // Define environment for the script.
   if (typeof(UltraEdit.columnModeOff) == "function") UltraEdit.columnModeOff();
   else if (typeof(UltraEdit.activeDocument.columnModeOff) == "function") UltraEdit.activeDocument.columnModeOff();
   UltraEdit.activeDocument.hexOff();

   // Must the script user enter the search string (or is it predefined)?
   if (!sSearchString.length)
   {
      sSearchString = UltraEdit.getString("Enter regular expression string to find text of interest:",1);
   }
   if (sSearchString.length)
   {
      // Search entire file with a not case sensitive regular expression.
      // As the script user can enter also an invalid regular expression,
      // catch this error and inform the script user about this mistake.
      var bValidExpression = true;
      try
      {
         var rRegSearch = new RegExp(sSearchString,"gi");
      }
      catch (Error)
      {
         OutputMessage("The entered search expression is an invalid regular expression.\n\n"+Error);
         bValidExpression = false;
      }

      if (bValidExpression)
      {
         // Does the search string contain opening and closing parentheses?
         if (sSearchString.search(/.*\([^?].*\).*/) >= 0)
         {
            // Ask user for regular expression string determining output of
            // found string except the replace string is predefined in script.
            if (!sReplaceString.length)
            {
               sReplaceString = UltraEdit.getString("Enter regular expression string for output:",1);
            }
         }
         else sReplaceString = "";  // No replace string if no marking group.

         // Search entire file with a not case sensitive regular expression
         // search which puts all found strings into an array of strings.
         UltraEdit.activeDocument.selectAll();

         // An error in the line below on script execution is caused usually by
         // a too large file for this script, use FindStringsToNewFileExtended.js.
         var asFoundStrings = UltraEdit.activeDocument.selection.match(rRegSearch);

         UltraEdit.activeDocument.top();  // Cancel selection.

         if (asFoundStrings != null)      // Was any string found?
         {
            // Has the script user entered a regular expression string for output?
            if (sReplaceString.length)
            {
               for (var nIndex = 0; nIndex < asFoundStrings.length; nIndex++)
               {
                  asFoundStrings[nIndex] = asFoundStrings[nIndex].replace(rRegSearch,sReplaceString);
               }
            }

            UltraEdit.newFile();          // Open a new file.
            // Insert a new line and get the new line character(s).
            UltraEdit.activeDocument.insertLine();
            UltraEdit.activeDocument.selectToTop();
            var sLineTerm = UltraEdit.activeDocument.selection;
            UltraEdit.activeDocument.deleteText();

            var bConvertToMac = false;
            if (sLineTerm == "\r")
            {                             // If the new file is a MAC file
               bConvertToMac = true;      // with just carriage returns
               sLineTerm = "\r\n";        // convert it temporary to DOS.
               UltraEdit.activeDocument.unixMacToDos();
            }

            // If version of UE/UES supports direct write to clipboard,
            // use user clipboard 9 to paste the found strings into the
            // new file as this is much faster than using write command.
            if (typeof(UltraEdit.clipboardContent) == "string")
            {
               var nActiveClipboard = UltraEdit.clipboardIdx;
               UltraEdit.selectClipboard(9);
               UltraEdit.clipboardContent = asFoundStrings.join(sLineTerm);
               UltraEdit.activeDocument.paste();
               UltraEdit.clearClipboard();
               UltraEdit.selectClipboard(nActiveClipboard);
            }
            else UltraEdit.activeDocument.write(asFoundStrings.join(sLineTerm));

            // Append one more line termination to terminate also last line.
            UltraEdit.activeDocument.insertLine();

            // Set caret to top of file with found strings and inform user
            // about number of strings found with the entered expression.
            UltraEdit.activeDocument.top();
            if (bConvertToMac) UltraEdit.activeDocument.dosToMac();
            var nCount = asFoundStrings.length;
            OutputMessage("Found "+nCount+" string"+(nCount==1?".":"s."));
         }
         else OutputMessage("No string found!");
      }
   }
   else OutputMessage("No regular expression string entered!");
}
else OutputMessage("You should have a file opened when you run this script!");
